/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import de.voidplus.leapmotion.LeapMotion;
import processing.core.PApplet;
import processing.core.PVector;

public class Pointable {
    protected PApplet parent;
    protected LeapMotion leap;
    protected com.leapmotion.leap.Pointable _pointable;

    public Pointable(PApplet pApplet, LeapMotion leapMotion, com.leapmotion.leap.Pointable pointable) {
        this.parent = pApplet;
        this.leap = leapMotion;
        this._pointable = pointable;
    }

    public int getId() {
        return this._pointable.id();
    }

    public PVector getPosition() {
        return this.leap.map(this._pointable.tipPosition());
    }

    public PVector getRawPosition() {
        return this.leap.convert(this._pointable.tipPosition());
    }

    public PVector getStabilizedPosition() {
        return this.leap.map(this._pointable.stabilizedTipPosition());
    }

    public PVector getRawStabilizedPosition() {
        return this.leap.convert(this._pointable.tipPosition());
    }

    public PVector getVelocity() {
        return this.leap.map(this._pointable.tipVelocity());
    }

    public PVector getRawVelocity() {
        return this.leap.convert(this._pointable.tipVelocity());
    }

    public PVector getDirection() {
        return new PVector(this._pointable.direction().getX(), -this._pointable.direction().getY(), this._pointable.direction().getZ());
    }

    public float getTouchDistance() {
        return this._pointable.touchDistance();
    }

    public int getTouchZone() {
        switch (this._pointable.touchZone()) {
            case ZONE_NONE: {
                return -1;
            }
            case ZONE_HOVERING: {
                return 0;
            }
            case ZONE_TOUCHING: {
                return 1;
            }
        }
        return -1;
    }

    public float getLength() {
        return this._pointable.length();
    }

    public float getTimeVisible() {
        return this._pointable.timeVisible();
    }

    protected boolean isFinger() {
        return this._pointable.isFinger();
    }

    protected boolean isTool() {
        return this._pointable.isTool();
    }
}

