/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import de.voidplus.leapmotion.Arm;
import de.voidplus.leapmotion.Finger;
import de.voidplus.leapmotion.LeapMotion;
import de.voidplus.leapmotion.RawAccess;
import de.voidplus.leapmotion.Tool;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;

public class Hand
implements PConstants,
RawAccess<com.leapmotion.leap.Hand> {
    protected PApplet parent;
    protected LeapMotion leap;
    private com.leapmotion.leap.Hand _hand;
    protected ArrayList<Finger> fingers;
    protected ArrayList<Finger> outstretchedFingers;
    protected ArrayList<Finger> outstretchedFingersByAngel;
    protected ArrayList<Tool> tools;

    public Hand(PApplet pApplet, LeapMotion leapMotion, com.leapmotion.leap.Hand hand) {
        this.parent = pApplet;
        this.leap = leapMotion;
        this._hand = hand;
        this.fingers = new ArrayList();
        this.outstretchedFingers = new ArrayList();
        this.outstretchedFingersByAngel = new ArrayList();
        this.tools = new ArrayList();
    }

    @Override
    public boolean isValid() {
        return this._hand.isValid();
    }

    @Override
    public com.leapmotion.leap.Hand getRaw() {
        return this._hand;
    }

    public int getId() {
        return this._hand.id();
    }

    public PVector getPosition() {
        return this.leap.map(this._hand.palmPosition());
    }

    public PVector getRawPosition() {
        return this.leap.convert(this._hand.palmPosition());
    }

    public PVector getPalmPosition() {
        return this.getPosition();
    }

    public PVector getStabilizedPosition() {
        return this.leap.map(this._hand.stabilizedPalmPosition());
    }

    public PVector getStabilizedPalmPosition() {
        return this.getStabilizedPosition();
    }

    public PVector getRawStabilizedPosition() {
        return this.leap.convert(this._hand.stabilizedPalmPosition());
    }

    public PVector getRawStabilizedParlmPosition() {
        return this.getRawStabilizedPosition();
    }

    public PVector getDirection() {
        return new PVector(PApplet.degrees((float)this._hand.direction().roll()), PApplet.degrees((float)this._hand.direction().pitch()), PApplet.degrees((float)this._hand.direction().yaw()));
    }

    public PVector getRawDirection() {
        return this.leap.convert(this._hand.direction());
    }

    public float getConfidence() {
        return this._hand.confidence();
    }

    public boolean isLeft() {
        return this._hand.isLeft();
    }

    public boolean isRight() {
        return this._hand.isRight();
    }

    public float getGrabStrength() {
        return this._hand.grabStrength();
    }

    public float getPinchStrength() {
        return this._hand.pinchStrength();
    }

    public float getTimeVisible() {
        return this._hand.timeVisible();
    }

    public Finger getFrontFinger() {
        return new Finger(this.parent, this.leap, this._hand.fingers().frontmost());
    }

    public Finger getLeftFinger() {
        return new Finger(this.parent, this.leap, this._hand.fingers().leftmost());
    }

    public Finger getRightFinger() {
        return new Finger(this.parent, this.leap, this._hand.fingers().rightmost());
    }

    public Tool getFrontTool() {
        return new Tool(this.parent, this.leap, this._hand.tools().frontmost());
    }

    public Tool getLeftTool() {
        return new Tool(this.parent, this.leap, this._hand.tools().leftmost());
    }

    public Tool getRightTool() {
        return new Tool(this.parent, this.leap, this._hand.tools().rightmost());
    }

    public PVector getDynamics() {
        return new PVector(this.getRoll(), this.getPitch(), this.getYaw());
    }

    public float getRoll() {
        return -PApplet.degrees((float)this._hand.palmNormal().roll());
    }

    public float getPitch() {
        return PApplet.degrees((float)this._hand.direction().pitch());
    }

    public float getYaw() {
        return PApplet.degrees((float)this._hand.direction().yaw());
    }

    public PVector getSpherePosition() {
        return this.leap.map(this._hand.sphereCenter());
    }

    public PVector getRawSpherePosition() {
        return this.leap.convert(this._hand.sphereCenter());
    }

    public float getSphereRadius() {
        return this._hand.sphereRadius();
    }

    public ArrayList<Finger> getFingers() {
        this.fingers.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this._hand.fingers()) {
                this.fingers.add(new Finger(this.parent, this.leap, finger));
            }
        }
        return this.fingers;
    }

    public ArrayList<Finger> getOutstretchedFingers() {
        this.outstretchedFingers.clear();
        if (!this._hand.fingers().extended().isEmpty()) {
            for (com.leapmotion.leap.Finger finger : this._hand.fingers().extended()) {
                this.outstretchedFingers.add(new Finger(this.parent, this.leap, finger));
            }
        }
        return this.outstretchedFingers;
    }

    public ArrayList<Finger> getOutstretchedFingers(int n) {
        return this.getOutstretchedFingers();
    }

    public ArrayList<Finger> getOutstretchedFingersByAngel(int n) {
        this.outstretchedFingersByAngel.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this._hand.fingers()) {
                if (!finger.isValid()) continue;
                Finger finger2 = new Finger(this.parent, this.leap, finger);
                float f = 0.0f;
                for (int i = 0; i < 4; ++i) {
                    f += PVector.dist((PVector)finger2.getBone(i).getNextJoint(), (PVector)finger2.getBone(i).getPrevJoint());
                }
                PVector pVector = finger2.getBone(0).getNextJoint();
                int n2 = finger2.getType() != 0 ? 3 : 2;
                float f2 = PVector.dist((PVector)pVector, (PVector)finger2.getBone(n2).getPrevJoint());
                if (!(f2 / f * 100.0f >= (float)n)) continue;
                this.outstretchedFingersByAngel.add(finger2);
            }
        }
        return this.outstretchedFingersByAngel;
    }

    public ArrayList<Finger> getOutstretchedFingersByAngel() {
        return this.getOutstretchedFingersByAngel(75);
    }

    public ArrayList<Finger> getRawOutstrechtedFingers() {
        this.outstretchedFingers.clear();
        return this.outstretchedFingers;
    }

    public boolean hasFingers() {
        return this.leap.isConnected() && !this._hand.fingers().isEmpty();
    }

    public int countFingers() {
        if (this.leap.isConnected()) {
            return this._hand.fingers().count();
        }
        return 0;
    }

    public Finger getFinger(int n) {
        for (Finger finger : this.getFingers()) {
            if (finger.getType() != n) continue;
            return finger;
        }
        return null;
    }

    public Finger getFinger(String string) {
        if ((string = string.toLowerCase()).equals("thumb")) {
            return this.getFinger(0);
        }
        if (string.equals("index")) {
            return this.getFinger(1);
        }
        if (string.equals("middle")) {
            return this.getFinger(2);
        }
        if (string.equals("ring")) {
            return this.getFinger(3);
        }
        if (string.equals("pinky")) {
            return this.getFinger(4);
        }
        return null;
    }

    public Finger getThumb() {
        return this.getFinger(0);
    }

    public Finger getIndexFinger() {
        return this.getFinger(1);
    }

    public Finger getMiddleFinger() {
        return this.getFinger(2);
    }

    public Finger getRingFinger() {
        return this.getFinger(3);
    }

    public Finger getPinkyFinger() {
        return this.getFinger(4);
    }

    public ArrayList<Tool> getTools() {
        this.tools.clear();
        if (this.hasTools()) {
            for (com.leapmotion.leap.Tool tool : this._hand.tools()) {
                this.tools.add(new Tool(this.parent, this.leap, tool));
            }
        }
        return this.tools;
    }

    public boolean hasTools() {
        if (this.leap.isConnected()) {
            return !this._hand.tools().isEmpty();
        }
        return false;
    }

    public int countTools() {
        if (this.leap.isConnected()) {
            return this._hand.tools().count();
        }
        return 0;
    }

    public Arm getArm() {
        return new Arm(this.parent, this.leap, this._hand.arm());
    }

    public boolean hasArm() {
        return this._hand.arm().isValid();
    }

    public void draw(float f) {
        Object object;
        this.parent.noStroke();
        this.parent.fill(0);
        PVector pVector = this.getPosition();
        if (this.leap.is2D) {
            this.parent.ellipseMode(3);
            this.parent.ellipse(pVector.x, pVector.y, f, f);
        } else {
            this.parent.pushMatrix();
            this.parent.translate(pVector.x, pVector.y, pVector.z);
            this.parent.sphereDetail(20);
            this.parent.sphere(f);
            this.parent.popMatrix();
        }
        if (this.hasArm()) {
            this.getArm().draw();
        }
        if (this.hasFingers()) {
            if (this.countFingers() == 5) {
                this.parent.stroke(0, 35.0f);
                this.parent.noFill();
                object = this.getThumb().getProximalBone().getPrevJoint();
                Finger finger = this.getIndexFinger().getMetacarpalBone().getPrevJoint();
                PVector pVector2 = this.getMiddleFinger().getMetacarpalBone().getPrevJoint();
                PVector pVector3 = this.getRingFinger().getMetacarpalBone().getPrevJoint();
                PVector pVector4 = this.getPinkyFinger().getMetacarpalBone().getPrevJoint();
                this.parent.beginShape();
                if (this.leap.is2D) {
                    this.parent.vertex(object.x, object.y);
                    this.parent.vertex(((PVector)finger).x, ((PVector)finger).y);
                    this.parent.vertex(pVector2.x, pVector2.y);
                    this.parent.vertex(pVector3.x, pVector3.y);
                    this.parent.vertex(pVector4.x, pVector4.y);
                } else {
                    this.parent.vertex(object.x, object.y, object.z);
                    this.parent.vertex(((PVector)finger).x, ((PVector)finger).y, ((PVector)finger).z);
                    this.parent.vertex(pVector2.x, pVector2.y, pVector2.z);
                    this.parent.vertex(pVector3.x, pVector3.y, pVector3.z);
                    this.parent.vertex(pVector4.x, pVector4.y, pVector4.z);
                }
                this.parent.endShape(1);
            }
            for (Finger finger : this.getFingers()) {
                finger.draw();
            }
        }
        this.parent.stroke(0);
        object = String.format("id: %d\nconfidence: %.2f\nhand side: %s\noutstretched fingers: %d\ntime visible: %.2f s\npinch strength: %.2f\ngrab strength: %.2f", this.getId(), Float.valueOf(this.getConfidence()), this.isLeft() ? "left" : "right", this.getOutstretchedFingers().size(), Float.valueOf(this.getTimeVisible()), Float.valueOf(this.getPinchStrength()), Float.valueOf(this.getGrabStrength()));
        if (this.leap.is2D) {
            this.parent.text((String)object, pVector.x - 30.0f, pVector.y - 150.0f);
        } else {
            this.parent.text((String)object, pVector.x - 30.0f, pVector.y - 150.0f, pVector.z);
        }
    }

    public void draw() {
        this.draw(5.0f);
    }

    public void drawFingers(int n) {
        if (this.hasFingers()) {
            for (Finger finger : this.fingers) {
                finger.draw(n);
            }
        }
    }

    public void drawFingers() {
        this.drawFingers(3);
    }

    public void drawSphere() {
        this.parent.stroke(0, 10.0f);
        this.parent.noFill();
        PVector pVector = this.getSpherePosition();
        float f = this.getSphereRadius();
        if (this.leap.is2D) {
            this.parent.ellipseMode(3);
            this.parent.ellipse(pVector.x, pVector.y, f, f);
        } else {
            this.parent.pushMatrix();
            this.parent.translate(pVector.x, pVector.y, pVector.z);
            this.parent.sphereDetail(12);
            this.parent.sphere(f);
            this.parent.popMatrix();
        }
    }
}

