/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import de.voidplus.leapmotion.Hand;
import de.voidplus.leapmotion.LeapMotion;
import java.util.ArrayList;
import processing.core.PApplet;

public abstract class Gesture {
    protected PApplet parent;
    protected LeapMotion leap;
    private com.leapmotion.leap.Gesture _gesture;

    public Gesture(PApplet pApplet, LeapMotion leapMotion, com.leapmotion.leap.Gesture gesture) {
        this.parent = pApplet;
        this.leap = leapMotion;
        this._gesture = gesture;
    }

    public boolean isValid() {
        return this._gesture.isValid();
    }

    public int getId() {
        return this._gesture.id();
    }

    public int getType() {
        if (this.isValid()) {
            switch (this._gesture.type()) {
                case TYPE_CIRCLE: {
                    return 0;
                }
                case TYPE_KEY_TAP: {
                    return 1;
                }
                case TYPE_SCREEN_TAP: {
                    return 2;
                }
                case TYPE_SWIPE: {
                    return 3;
                }
            }
            return -1;
        }
        return -1;
    }

    public long getDuration() {
        return this._gesture.duration();
    }

    public float getDurationInSeconds() {
        return this._gesture.durationSeconds();
    }

    public boolean hasHands() {
        return !this._gesture.hands().isEmpty();
    }

    public int countHands() {
        if (this.hasHands()) {
            return this._gesture.hands().count();
        }
        return 0;
    }

    public ArrayList<Hand> getHands() {
        ArrayList<Hand> arrayList = new ArrayList<Hand>();
        if (this.hasHands()) {
            for (com.leapmotion.leap.Hand hand : this._gesture.hands()) {
                arrayList.add(new Hand(this.parent, this.leap, hand));
            }
        }
        return arrayList;
    }
}

