/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import com.leapmotion.leap.Bone;
import de.voidplus.leapmotion.LeapMotion;
import de.voidplus.leapmotion.RawAccess;
import processing.core.PApplet;
import processing.core.PVector;

public class Bone
implements RawAccess<com.leapmotion.leap.Bone> {
    protected PApplet parent;
    protected LeapMotion leap;
    private com.leapmotion.leap.Bone _bone;

    public Bone(PApplet pApplet, LeapMotion leapMotion, com.leapmotion.leap.Bone bone) {
        this.parent = pApplet;
        this.leap = leapMotion;
        this._bone = bone;
    }

    @Override
    public boolean isValid() {
        return this._bone.isValid();
    }

    @Override
    public com.leapmotion.leap.Bone getRaw() {
        return this._bone;
    }

    public int getType() {
        Bone.Type type = this._bone.type();
        switch (type) {
            case TYPE_DISTAL: {
                return 0;
            }
            case TYPE_INTERMEDIATE: {
                return 1;
            }
            case TYPE_PROXIMAL: {
                return 2;
            }
            case TYPE_METACARPAL: {
                return 3;
            }
        }
        return -1;
    }

    public float getBoneLength() {
        return this._bone.length();
    }

    public float getBoneWidth() {
        return this._bone.width();
    }

    public PVector getNextJoint() {
        return this.leap.map(this._bone.nextJoint());
    }

    public PVector getRawNextJoint() {
        return this.leap.convert(this._bone.nextJoint());
    }

    public PVector getPrevJoint() {
        return this.leap.map(this._bone.prevJoint());
    }

    public PVector getRawPrevJoint() {
        return this.leap.convert(this._bone.prevJoint());
    }

    public PVector getDirection() {
        return this.leap.map(this._bone.direction());
    }

    public PVector getRawDirection() {
        return this.leap.convert(this._bone.direction());
    }

    public void draw() {
        this.parent.noFill();
        PVector pVector = this.getNextJoint();
        PVector pVector2 = this.getPrevJoint();
        this.parent.beginShape(5);
        if (this.leap.is2D) {
            this.parent.vertex(pVector.x, pVector.y);
            this.parent.vertex(pVector2.x, pVector2.y);
        } else {
            this.parent.vertex(pVector.x, pVector.y, pVector.z);
            this.parent.vertex(pVector2.x, pVector2.y, pVector2.z);
        }
        this.parent.endShape(1);
    }
}

