/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.util.Objects;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.MacOSXPreferencesFile;
import java.util.prefs.Preferences;

class MacOSXPreferences
extends AbstractPreferences {
    private static final String defaultAppName = "com.apple.java.util.prefs";
    private final boolean isUser;
    private final boolean isRoot;
    private final MacOSXPreferencesFile file;
    private final String path;
    private static MacOSXPreferences userRoot = null;
    private static MacOSXPreferences systemRoot = null;

    static synchronized Preferences getUserRoot() {
        if (userRoot == null) {
            userRoot = new MacOSXPreferences(true);
        }
        return userRoot;
    }

    static synchronized Preferences getSystemRoot() {
        if (systemRoot == null) {
            systemRoot = new MacOSXPreferences(false);
        }
        return systemRoot;
    }

    private MacOSXPreferences(boolean bl) {
        this(null, "", false, true, bl);
    }

    private MacOSXPreferences(MacOSXPreferences macOSXPreferences, String string) {
        this(macOSXPreferences, string, false, false, false);
    }

    private MacOSXPreferences(MacOSXPreferences macOSXPreferences, String string, boolean bl) {
        this(macOSXPreferences, string, bl, false, false);
    }

    private MacOSXPreferences(MacOSXPreferences macOSXPreferences, String string, boolean bl, boolean bl2, boolean bl3) {
        super(macOSXPreferences, string);
        this.isRoot = bl2;
        this.isUser = bl2 ? bl3 : this.isUserNode();
        this.path = bl2 ? this.absolutePath() : this.absolutePath() + "/";
        this.file = this.cfFileForNode(this.isUser);
        this.newNode = bl ? bl : this.file.addNode(this.path);
    }

    private MacOSXPreferencesFile cfFileForNode(boolean bl) {
        String string = this.path;
        boolean bl2 = false;
        int n = -1;
        for (int i = 0; i < 4 && (n = string.indexOf(47, n + 1)) != -1; ++i) {
        }
        if (n == -1) {
            string = defaultAppName;
        } else {
            string = string.substring(1, n);
            string = string.replace('/', '.');
            string = string.toLowerCase();
        }
        return MacOSXPreferencesFile.getFile(string, bl);
    }

    @Override
    protected void putSpi(String string, String string2) {
        this.file.addKeyToNode(this.path, string, string2);
    }

    @Override
    protected String getSpi(String string) {
        return this.file.getKeyFromNode(this.path, string);
    }

    @Override
    protected void removeSpi(String string) {
        Objects.requireNonNull(string, "Specified key cannot be null");
        this.file.removeKeyFromNode(this.path, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            ((MacOSXPreferences)this.parent()).removeChild(this.name());
            this.file.removeNode(this.path);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void removeChild(String string) {
        this.file.removeChildFromNode(this.path, string);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        String[] stringArray = this.file.getChildrenForNode(this.path);
        if (stringArray == null) {
            throw new BackingStoreException("Couldn't get list of children for node '" + this.path + "'");
        }
        return stringArray;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        String[] stringArray = this.file.getKeysForNode(this.path);
        if (stringArray == null) {
            throw new BackingStoreException("Couldn't get list of keys for node '" + this.path + "'");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractPreferences childSpi(String string) {
        Class<MacOSXPreferencesFile> clazz = MacOSXPreferencesFile.class;
        synchronized (MacOSXPreferencesFile.class) {
            boolean bl = this.file.addChildToNode(this.path, string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new MacOSXPreferences(this, string, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isUser ? !MacOSXPreferencesFile.flushUser() : !MacOSXPreferencesFile.flushWorld()) {
                throw new BackingStoreException("Synchronization failed for node '" + this.path + "'");
            }
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node has been removed");
            }
            if (this.isUser ? !MacOSXPreferencesFile.syncUser() : !MacOSXPreferencesFile.syncWorld()) {
                throw new BackingStoreException("Synchronization failed for node '" + this.path + "'");
            }
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

