//   "Restoring the Void" GAME DESCRIPTION
//   You are the singular massive black hole residing within the void. 
//   An outburst of energy has errupted through the ether into the void.
///  The outburst is corrupting the void leaving trails of bright energy throughout. 
//   To counter, you must trap the resistant outburst within your gravitational pull,
//   contain its energy and snuff it out, bit by bit, click by click,
//   ending this disruption and restoring nothingness back to the void. 

/////ADDITIONAL LIBRARIES/////
import de.voidplus.leapmotion.*;
import processing.sound.*;

////CLASSES////

EnergyTest eTest = new EnergyTest();
RandomOpeningText quotes = new RandomOpeningText();
restartGame rG = new restartGame();
LeapDrawClass leapC = new LeapDrawClass();
voidSoundDesign vSD = new voidSoundDesign();

// PGraphics to make layers //

PGraphics backgroundDraw;
PGraphics egOutBurst;
PGraphics engTrail;
PGraphics blackHole;
PGraphics bhOutline;
PGraphics bhStrike;
PGraphics endVoid;
PGraphics onlyVoidText;
PGraphics capturedEnergyAnim;
PGraphics lightRays;
PGraphics engOutMini;
PGraphics bhTitle;

//Game Sections varialbes//
boolean prePlay = true;
boolean gamePlay = false;
boolean tutorialScreen = true;
boolean startScreen = false;
boolean storyScreen = false;
boolean endScreen = false;



////CALL UP LEAP DEVICE////
LeapMotion leap;

////ENERGY CAPTURED BOOL////
boolean energyCaptured = false;

//////LEAP MOTION VARIABLES/////

float   handPinch;
float   handGrab;
PVector handPosition;
PVector handStabilized;
float leapX;
float leapY;
float leapZ;

float easeX;
float easeY;
float easing = 0.2;

///LEAP HAND CLICK BASED VARIABLES////
int handClicking = 0;
boolean handClicked = false;
boolean handIsRight;
float clickCount = 0;
float fingerCount;

int numOut; ////Number of fingers extended


///HAND CONTROL FROM LEAP & MAPPING////
float rightHandX = width;
float rightHandY = height;


float mapRightHandX;
float mapRightHandY;


float damageT = 0;

///Opening Text Swtich STatmenet Variables///
String OpenText = "";
int openTextNumber = (int)random(1, 38);
//int openTextNumber = (39);


//Energy Variables//
float egX; // energy  x coordinate
float egY; // energy  y coordinate
float egGrow; //Makes the energy trail slowly grow larger over time
float damage; //holds value of damage so three clicks destroys energy
float antiGravityClose; //holds value of lerp/resistance to black hole when at a nearer distance
float antiGravityFar; //holds value of lerp/resistance to black hole when at a greater distance
float noAntiGravity; /// if captured
boolean energyDestroyed = false;  // deactivates energy if true

float etX; // energy  TUTORIAL x coordinate 
float etY; // energy TUTORIAL y coordinate

//Captured Energy Animation Variables//
float eCaptureX = egX;
float eCaptureY = egX;
float eCaptureLerp = lerp(eCaptureX, eCaptureY, .02);
float randomScale = random(0, .02);

//black hole and Void Variables//
float bhX = width; // black hole x coordinate
float bhY = height; // black hole y coordinate
float voidGrow; //end when void wins

///ONGOING VARIABLES///
float textDrift;
float textTimer; // starts timer from energyDestroyed to calibrade text fade up

//End Scenes Variables//
float endTextColor = 0;
boolean thereIsOnlyVoid = false; // End play again text twist
float onlyVtextX;
float onlyVtextY;

//start screen variables//

float startStoryR = 255;
float startPlayR = 255;
float fadeByMouse = 0;

float instructionBoxHeight;

/////PDF FRAME RECORD////
//boolean record = false;
//float recordFrameNum = 0;

float fading = constrain(0, 0, 255);


//float fadingUp = 0;
//float fadingDown =255;

boolean blankStart = false;
boolean text1 = true;
boolean text2 = false;
boolean text3 = false;
boolean text4 = false;
boolean text5 = false;
boolean text6 = false;
boolean text7 = false;

boolean setFadeUp =false;
boolean setFadeDown = false;
boolean fadeUp = true;
boolean fadeDown = false;

////MILLIS  TIMER ////
float m = 0;
float last = 0;

////Image Capture Variable number////

float screenShots = 0;

///SOUND DESIGN VARIABLES/////
PinkNoise noise;
LowPass lowPass;
BandPass bandPass;

float amp=0.0;
float freq=200;
float AngryVoidSound = 100;

SqrOsc sqr;
 
/////Death Pulse/////
Pulse pulse;
float destroyBlowLevel = 0;
float dbRandoAdd = destroyBlowLevel + random(2,10);
float dbPan = 0;
float voidAmp;
boolean destroyBlowUp = false;
boolean destroyBlowDown = false;
boolean destroyBlowPause = true;
boolean dbRandoAddOnOff = false;
boolean energyInvading = false;

////SETTINGS FOR SCREEN ///

void settings() {

  if (displayHeight >906) {

    size(1400, 906);
    instructionBoxHeight = 120;
  } 
  if (displayHeight <= 906 && displayHeight > 841) { 
    size(1300, 841);
    instructionBoxHeight = 120;
  } 
  if (displayHeight <= 841 && displayHeight > 776) {
    size(1200, 776);
    instructionBoxHeight = 120;
  } 
  if (displayHeight <= 776 && displayHeight > 647) {
    size(1100, 712);
    ;
    instructionBoxHeight = 140;
  } 
  if (displayHeight <= 712 && displayHeight > 647) {
    size(1000, 647);
    instructionBoxHeight = 140;
  }  
  if  (displayHeight <= 647) {
    size(displayWidth - 70, displayHeight - 70);
    instructionBoxHeight = 160;
  }
}




void setup() {
  //size(1400, 906);
  //fullScreen();
  noCursor();
  //Original Background//
  background(5);

  ///LEAP INITIALIZE///
  leap = new LeapMotion(this);

 /////SOUND INITIALIZE////
  noise = new PinkNoise(this);
  bandPass = new BandPass(this);
  sqr = new SqrOsc(this);
  pulse = new Pulse(this);
  vSD.soundSetup();
  
  
  //PGraphics Layers Created//
  backgroundDraw = createGraphics(width, height);
  egOutBurst = createGraphics(width, height);
  engTrail = createGraphics(width, height);
  engOutMini = createGraphics(width, height);
  blackHole = createGraphics(width, height);
  bhOutline = createGraphics(width, height);
  bhStrike = createGraphics(width, height);
  endVoid = createGraphics(width, height);
  onlyVoidText = createGraphics(width, height);
  capturedEnergyAnim = createGraphics(width, height);
  lightRays = createGraphics(width, height);
  bhTitle = createGraphics(width, height);

  //SETUP PREPLAY///
  prePlay = true;


  //EndScene Variable Settings//
  textTimer = 0;


  // Damage to energy dot and destruction variables//
  energyDestroyed = false;
  damage = 0; 


  //Energy Variables Settings//
  egX = random(200, 1000);
  egY = random(200, 400);
  egGrow = 5;
  voidGrow = 5;
  antiGravityFar = -.1;
  antiGravityClose = -.5;
  noAntiGravity = 1;

  mapRightHandX = width;
  mapRightHandY = height;
  //EndScene Variable Settings//
  textTimer = 0;
}

//FUNCTIONALITY, ANIMATION, & ART//

void draw() {
 println(textTimer);
 

 
 
if (keyPressed == true)  {
  if (key == 'q') {
   saveFrame("RestoringTheVoid_ImageSave/BeforeThereWasVoid" + hour() + minute() + second() + month() + year() + ".png");
  }
  
}



  rG.reset();
  vSD.soundDraw();
  leapC.leapDraw();
  
  /////EASEING PARAMETERS FOR CAPTURED ENERGY/////
   float targetX = leapX;
   float dx = targetX - easeX;
   easeX += dx * easing;
   
   float targetY =leapY;
   float dy = targetY - easeY;
   easeY += dy * easing;
   /////////////////////////////////////////////
   

 if (energyCaptured == false) {
   rightHandX = mouseX;
   rightHandY = mouseY;
 } 
 else {
   
   rightHandX = mouseX;
   rightHandY = mouseY;
   
 }
   mapRightHandX =   mouseX;
   mapRightHandY =   mouseY;

 // mapRightHandX =   (constrain(map(rightHandX, 200, width-200, 0, width), 0, width));
 // mapRightHandY =   (constrain(map(rightHandY, 200, height-300, 0, height), 0, height));
  

  if (setFadeUp==true) {
    fading = 0;
    setFadeUp = false;
  }
  
  if (setFadeDown == true) {
    fading = 500;
    setFadeDown = false;
  }

  if (prePlay==true) {


    ////////MIGHT HAVE TO INITIALIZE LEAP AGAIN HERE////////
 leapC.leapDraw();


    //////////INITIALIZE HAND CONTROL LERP & SORT//////////////////////////

    eCaptureLerp = lerp(width/2, height/2, .6);
    fadeByMouse = mapRightHandX;

    //Blackhole mouse control setup //
    bhX = mapRightHandX;
    bhY = mapRightHandY; 


    ///////LOAD PREPLAY PGRAPHICS LAYERS/////////////////////////////////////////
    image(backgroundDraw, 0, 0);


    //blendMode(BLEND);

    image(engTrail, 0, 0);
    image(blackHole, 0, 0);
    image(lightRays, 0, 0);

    //// black dot in middle of VOID////
    fill(0);
    noStroke();
    ellipse(width/2, height/2, 82, 82);

    image(capturedEnergyAnim, 0, 0);
    image(bhOutline, 0, 0);
    image(egOutBurst, 0, 0);



    /////////////////////////////////////////////////////////////////////////////
    //////////////////PRE-PLAY CONSTANT BACKGROUND///////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    backgroundDraw.beginDraw();
    backgroundDraw.background(24);
    backgroundDraw.endDraw();



    //BLACK HOLE IMAGE FROM GAME PLAY//
    blackHole.beginDraw();
    blackHole.clear();
    blackHole.translate(-width*3.5, -height*3.5);
    blackHole.scale(8);
    blackHole.stroke(255, 100 + (sin(frameCount/10)*40));
    blackHole.strokeWeight(20);
    blackHole.noFill();
    blackHole.ellipse(width/2, height/2, 30, 30);
    blackHole.ellipse(width/2, height/2, 40, 40);
    blackHole.ellipse(width/2, height/2, 50, 50);
    blackHole.strokeWeight(0);
    blackHole.ellipse(width/2, height/2, 100, 100);
    blackHole.fill(0, 200 + (sin(frameCount/12)*80));
    blackHole.noStroke();
    blackHole.ellipse(width/2, height/2, 30, 30);
    blackHole.blendMode(MULTIPLY);
    blackHole.filter(THRESHOLD);
    blackHole.endDraw();



    //////////////ANTI-MATTER////////////////
    if (handClicked == true && energyDestroyed==false) {

      engTrail.beginDraw();
      engTrail.blendMode(DIFFERENCE);
      engTrail.fill(random(2, 10), random(3, 15), random(10, 50), 100);
      engTrail.noStroke();
      engTrail.ellipse(bhX+(random(-50, 100)), bhY+(random(-100, 200)), 20, 20);
      engTrail.ellipse(bhX+(random(-30, 30)), bhY+(random(-20, 20)), 20, 20);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 50, 50);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 20, 20);
      engTrail.ellipse(bhX+(random(-100, 50)), bhY+(random(-50, 50)), 20, 20);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-100, 100)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.blendMode(DARKEST);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);

      engTrail.endDraw();
    } else {
      engTrail.beginDraw();
      engTrail.endDraw();
    }



    /////////////////////////////////////////////////////////////////////////////
    /////////////////////BLACK HOLD HAND CONTROL//////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////

    //// BLACK HOLE CURSER OPEN SCREEN ///
    if ( handClicked==false && handClicking==1) {

      bhOutline.beginDraw();
      bhOutline.clear();
      bhOutline.stroke(random(10, 20), 20, 10, 50 + (sin(frameCount/10)*40));
      bhOutline.strokeWeight(20);
      bhOutline.noFill();
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 30, 30);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 40, 40);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 50, 50);
      bhOutline.fill(10, 200 + (sin(frameCount/8)*80));
      bhOutline.noStroke();
      bhOutline.ellipse(bhX, bhY, 30, 30);
      bhOutline.blendMode(BLEND);

      bhOutline.noFill();
      bhOutline.strokeWeight(3);
      bhOutline.stroke(50, random(50, 200));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 60, 60);
      bhOutline.strokeWeight(10);
      bhOutline.stroke(10, random(5, 100), random(10, 200), random(10, 150));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 70, 70);
      bhOutline.strokeWeight(2);
      bhOutline.stroke(random(2, 15), random(4, 50), random(11, 50), random(50, 100));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 80, 80);
      bhOutline.endDraw();
    } else {


      bhOutline.beginDraw();
      bhOutline.clear();
      bhOutline.stroke(50, 100 + (sin(frameCount/10)*40));
      bhOutline.strokeWeight(20);
      bhOutline.noFill();
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 30, 30);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 40, 40);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 50, 50);
      bhOutline.fill(10, 200 + (sin(frameCount/8)*80));
      bhOutline.noStroke();
      bhOutline.ellipse(bhX, bhY, 30, 30);
      bhOutline.blendMode(BLEND);

      bhOutline.noFill();
      bhOutline.strokeWeight(3);
      bhOutline.stroke(50, random(50, 200));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 60, 60);
      bhOutline.strokeWeight(10);
      bhOutline.stroke(10, random(100, 200));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 70, 70);
      bhOutline.strokeWeight(2);
      bhOutline.stroke(10, random(50, 100));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 80, 80);
      bhOutline.endDraw();
    }



    /////////////////////////////////////////////////////////////////////////////
    ///////////////////////////PREPLAY TUTORIAL//////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////


    if (tutorialScreen == true) {



      if (fadeUp==true) {
        fading = fading +2 ;
      }
      if (fadeDown==true) {
        fading = fading - 15 ;
      }



      if (text1==true) {
        quotes.openTextQuotes();

        textTimer = textTimer +1;
        rectMode(CENTER);
        textAlign(CENTER);
        textSize(24);
        noStroke();
        fill(255, 255, 255, -100+ fading + random(-100, 100));
        text(OpenText, width/2, height/2 + 35, 750, 100);
        rectMode(LEFT);

        textSize(19);
        textAlign(CENTER);
        fill(138, 137, 171, -700+ fading *2);
        text("CLICK MOUSE TO BEGIN", width - 300, height -  75);




        if (handClicked == true && fadeUp ==true) {

         
          
          setFadeDown = true;
          fadeUp = false;
          fadeDown = true;
        }

        if (fadeDown==true && fading<=0) {
          setFadeUp=true;
          fadeUp = true;
          fadeDown=false;
          textTimer = 0;
          text2 = true;  
          text1 = false;
         

        }
      }

      if (text2==true) {

        text1 = false;

        textAlign(CENTER);
        textSize(24);
        noStroke();
        fill(255, 255, 255, fading + random(2, 15));
        text("YOU ARE A COLLOSAL BLACK HOLE RESIDING WITHIN THE VOID", width/2, height/2 - 20);
        fill(255, 255, 255, - 100 + fading + random(2, 15));
        text("HOLD DOWN MOUSE BUTTON TO INCREASE YOUR GRAVITATIONAL PULL", width/2, height/2 + 30);

        textSize(19);
        textAlign(CENTER);
        fill(138, 137, 171, -600+ fading *2);
        text("HOLD MOUSE BUTTON TO CONTINUE", width - 300, height -  75);

        if (handClicking == 1) {
          textTimer = textTimer +1;
        }
        if (textTimer>=60) {
       
          fadeUp = false;
          fadeDown= true;
        }

        if (fadeDown==true && fading<=0) {
          textTimer = textTimer +1;
          setFadeUp=true;
          fadeDown=false;
          fadeUp = true;
          textTimer = 0;
          text3 = true;  
          text2 = false;
           
        }
      }

      if (text3==true) {
        text2 = false;


        textAlign(CENTER);
        textSize(24);
        noStroke();
        fill(255, 255, 255, fading + random(2, 15));
        text("RELEASE MOUSE BUTTON TO EXPEL DESTRUCTIVE ANTI-MATTER", width/2, height/2);

        textSize(19);
        textAlign(CENTER);
        fill(138, 137, 171, -600+ fading *2);
        text("RELEASE MOUSE BUTTON TO CONTINUE", width - 300, height -  75);


        if (handClicked ==true) {
        setFadeUp=true;
         fadeUp = false;
         fadeDown=true;
         
        }
        if (fadeDown==true && fading<=0) {
          textTimer = textTimer +1;
          setFadeUp=true;
          fadeDown=false;
          fadeUp = true;
          textTimer = 0;
          text4 = true;  
          text3 = false;
          
        }
      }



      if (text4==true) {
        text3 = false;
        eTest.EnergyOutburstTut();


        textAlign(CENTER);
        textSize(24);
        noStroke();
        fill(255, 255, 255, fading + random(2, 15));
        text("ROGUE OUTBURSTS OF BRIGHT ENERGY THREATEN THE FAMILIAR NOTHINGNESS", width/2, height/2-20);
        fill(255, 255, 255, - 100 + fading + random(2, 15));
        text("TRAP THEM WITH YOUR GRAVITY AND DESTROY WITH ANTI-MATTER", width/2, height/2 + 30);

        textSize(19);
        textAlign(LEFT);
        fill(138, 137, 171, -400+ fading *2);
        text("MOVE MOUSE TO TRAP ENERGY\nCLICK MOUSE TO DESTROY TRAPPED ENERGY", width - 500, height -  75);
      }

      if (text5 ==true) {
        text4 = false;
    
        
        //if (fading>=255){
        //  fadeUp=false;
        //  fadeDown=true;
        //}


        textAlign(CENTER);
        textSize(24);
        noStroke();
        fill(255, 255, 255, fading + random(2, 15));
        text("MOVE FAST", width/2, height/2-35);
        fill(255, 255, 255, - 100 +fading + random(2, 15));
        text("DESTROY ENERGY", width/2, height/2+15);
        fill(255, 255, 255, - 200 +fading + random(2, 15));
        text("RESTORE THE VOID", width/2, height/2+65);

        if (fading>=400 && fading<402) {

          fill (235);
          rect(0, 0, width, height);
        } else if (fading>=402 && startScreen==false) {

          textTimer = 0;
          setFadeUp=true;
          fadeUp = true;
          fadeDown=false;
          textTimer = 0;
          text5 = false;  
          text6= true;
          startScreen = true;
          
        }
      }
    }
  }



  // This if statment initializes Start Screen for interface//


  if (startScreen==true) {
    prePlay = false;
    tutorialScreen = false;

    endScreen = false;

    //Blackhole mouse control setup //
    bhX = mapRightHandX;
    bhY = mapRightHandY; 

    textTimer = textTimer +1;



    eCaptureLerp = lerp(width/2, height/2, .6);
    fadeByMouse = mapRightHandX;

    //////////PGRAPHIC IMAGE CALL UPS////////////
    //////////////////FOR TITLE SCREEN///////////
    background(25); 
    image(backgroundDraw, 0, 0);
    image(engTrail, 0, 0);
    image(bhTitle, 0, 0);
    image(lightRays, 0, 0);
    //blendMode(REPLACE);
    fill(0);
    noStroke();
    ellipse(width/2, height/2, 82, 82);
    //blendMode(BLEND);


    image(bhOutline, 0, 0);

    //BLACK HOLE IMAGE for TITLE//
    bhTitle.beginDraw();
    bhTitle.clear();
    bhTitle.translate(-width*3.5, -height*3.5);
    bhTitle.scale(8);
    bhTitle.stroke(255, 100 + (sin(frameCount/10)*40));
    bhTitle.strokeWeight(20);
    bhTitle.noFill();
    bhTitle.ellipse(width/2, height/2, 30, 30);
    bhTitle.ellipse(width/2, height/2, 40, 40);
    bhTitle.ellipse(width/2, height/2, 50, 50);
    bhTitle.strokeWeight(0);
    bhTitle.ellipse(width/2, height/2, 100, 100);
    bhTitle.fill(0, 200 + (sin(frameCount/12)*80));
    bhTitle.noStroke();
    bhTitle.ellipse(width/2, height/2, 30, 30);
    bhTitle.blendMode(MULTIPLY);
    //bhTitle.filter(THRESHOLD);
    bhTitle.endDraw();

    //ENERGY LIGHT AT BOTTOM OF BLACK HOLE TITLE//

    lightRays.beginDraw();
    lightRays.clear();
    lightRays.noStroke();
    lightRays.fill(255); 
    //lightRays.blendMode(LIGHTEST);
    lightRays.stroke(random(100, 247), 230, random(111, 255), random(150, 255)* map(mapRightHandX, 0+width/15, width-width/8, 0, 1));
    lightRays.strokeCap(SQUARE);
    lightRays.strokeWeight(random(3, 9));
    lightRays.ellipse(width/2, height/2, 10, 10);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 - random(0, 100) + eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(-20, 20), height/2 - random(0, 125)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 - random(0, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 - random(1, 100)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 + random(50, 100)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 + random(-50, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(20, 100), height/2 + random(25, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(0, 100), height/2 + random(-100, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(0, 100), height/2 + random(0, 100)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(0, 100), height/2 - random(0, 100)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 - random(0, 100) + eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(-20, 20), height/2 - random(0, 125)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 - random(0, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 - random(1, 100)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 + random(50, 100)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(0, 100), height/2 + random(-50, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 - random(20, 100), height/2 + random(25, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(0, 100), height/2 + random(-100, 50)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(0, 100), height/2 + random(0, 100)+ eCaptureLerp);
    lightRays.line(width/2, height/2, width/2 + random(0, 100), height/2 - random(0, 100)+ eCaptureLerp);
    lightRays.fill(0);
    lightRays.ellipse(width/2, height/2, 30, 30);
    lightRays.endDraw();





    //////////////ANTI-MATTER////////////////
    if (handClicked == true && energyDestroyed==false) {

      engTrail.beginDraw();
      engTrail.blendMode(DIFFERENCE);
      engTrail.fill(random(2, 10), random(3, 15), random(10, 50), 100);
      engTrail.noStroke();
      engTrail.ellipse(bhX+(random(-50, 100)), bhY+(random(-100, 200)), 20, 20);
      engTrail.ellipse(bhX+(random(-30, 30)), bhY+(random(-20, 20)), 20, 20);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 50, 50);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 20, 20);
      engTrail.ellipse(bhX+(random(-100, 50)), bhY+(random(-50, 50)), 20, 20);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-100, 100)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.blendMode(DARKEST);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-10, 10)), 5, 5);

      engTrail.endDraw();
    } else {
      engTrail.beginDraw();
      engTrail.endDraw();
    }



    /////////////////////////////////////////////////////////////////////////////
    /////////////////////BLACK HOLD mouse CONTROL//////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////

    //// BLACK HOLE CURSER OPEN SCREEN ///
    if ( handClicked==false && handClicking==1) {

      bhOutline.beginDraw();
      bhOutline.clear();
      bhOutline.stroke(random(10, 20), 20, 10, 50 + (sin(frameCount/10)*40));
      bhOutline.strokeWeight(20);
      bhOutline.noFill();
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 30, 30);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 40, 40);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 50, 50);
      bhOutline.fill(10, 200 + (sin(frameCount/8)*80));
      bhOutline.noStroke();
      bhOutline.ellipse(bhX, bhY, 30, 30);
      bhOutline.blendMode(BLEND);

      bhOutline.noFill();
      bhOutline.strokeWeight(3);
      bhOutline.stroke(50, random(50, 200));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 60, 60);
      bhOutline.strokeWeight(10);
      bhOutline.stroke(10, random(5, 100), random(10, 200), random(10, 150));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 70, 70);
      bhOutline.strokeWeight(2);
      bhOutline.stroke(random(2, 15), random(4, 50), random(11, 50), random(50, 100));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 80, 80);
      bhOutline.endDraw();
    } else {


      bhOutline.beginDraw();
      bhOutline.clear();
      bhOutline.stroke(50, 100 + (sin(frameCount/10)*40));
      bhOutline.strokeWeight(20);
      bhOutline.noFill();
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 30, 30);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 40, 40);
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 50, 50);
      bhOutline.fill(10, 200 + (sin(frameCount/8)*80));
      bhOutline.noStroke();
      bhOutline.ellipse(bhX, bhY, 30, 30);
      bhOutline.blendMode(BLEND);

      bhOutline.noFill();
      bhOutline.strokeWeight(3);
      bhOutline.stroke(50, random(50, 200));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 60, 60);
      bhOutline.strokeWeight(10);
      bhOutline.stroke(10, random(100, 200));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 70, 70);
      bhOutline.strokeWeight(2);
      bhOutline.stroke(10, random(50, 100));
      bhOutline.ellipse(mapRightHandX, mapRightHandY, 80, 80);
      bhOutline.endDraw();
    }




    textAlign(LEFT);
    textSize(30);
    noStroke();
    fill(255, 255, 255, textTimer - 150 + random(0, 255));
    text("RESTORING", .12* width, height/2 + 15);
    fill(255, 255, 255, textTimer - 210 + random(0, 255));
    textAlign(CENTER);
    text("THE VOID", width/2, height/2 + 15); 
    textSize(20);



    //Game Play Buttons //

    textAlign(LEFT);
    fill(startStoryR, 255, 255, textTimer-50);
    text("begin", .12* width, height/2 + 55);






    //Button Highlights on hover//

    if (mapRightHandX>.05*width && mapRightHandX<.25* width && mapRightHandY>height/2 - 50 && mapRightHandY<height/2+100) {
      startStoryR = 0;
    } else {
      startStoryR = 255;
    }



    //  Initiate GAME PLAY // 

    if (mapRightHandX>.05*width && mapRightHandX<.25* width && mapRightHandY>height/2 - 50 && mapRightHandY<height/2+100 && startScreen==true && handClicked || dist(mapRightHandX, mapRightHandY, width/2, height/2)<150 && handClicked) {

      prePlay = false;
      tutorialScreen = true;
      startScreen = false;
      storyScreen = false;
      endScreen = false;
      gamePlay = true;
      textTimer = 0;
    } 


    image(capturedEnergyAnim, 0, 0);
  }   







  ////////////////////////////////////////////////////////////////  
  //////// Game Plays only if this if statement is true//////////  
  ///////////////////////////////////////////////////////////////


  if (gamePlay==true) {
    prePlay = false;
    tutorialScreen = false;
    startScreen = false;
    storyScreen = false;
    endScreen = false;
    //setting up variables for energy speed and growth //
    noCursor();
    //BACKGROUND VOID SETUP//

    if (energyDestroyed == true && textTimer == -90) {
vSD.soundEngDamaged();
    } else


    //println("gameplay = " + gamePlay);

    // Energy Trail anit-Gravity and grow setups //

    if (damage==0) {
      antiGravityFar = -.05;
      antiGravityClose = -.5;
      noAntiGravity = 1;
      egGrow = egGrow + random(.01, .09);
    }

    if (damage==1) {
      antiGravityFar = -.055;
      antiGravityClose = -.55;
    //  noAntiGravity = 1;
      egGrow = egGrow + random(.01, .09);
    }

    if (damage==2) {
      antiGravityFar = -.06;
      antiGravityClose = -.6;
     // noAntiGravity = 1;
      egGrow = egGrow + random(.01, .09);
    }

    if (damage==3) {
      antiGravityFar = -.065;
      antiGravityClose = -.65;
     // noAntiGravity = 1;
      egGrow = 25;
    }

    // Energy Trail random motion by distance when damage is 3//

    if (damage==3 && dist(bhX, bhY, egX, egY)<25) {
      egX = egX + random(-15, 15);
      egY = egY + random(-15, 15);
    } else if (damage==3 && dist(bhX, bhY, egX, egY)>30) {
      egX = egX + random(-20, 20);
      egY = egY + random(-20, 20);
    } else {
      egX = egX + random(-13, 13);
      egY = egY + random(-13, 13);
      egGrow = egGrow + random(.01, .09);
    }

    //Energy Captured Animation Variables Set)
    eCaptureX = egX;
    eCaptureY = egY;
    eCaptureLerp = 0;

    //Blackhole mouse control setup //

    bhX = mapRightHandX;
    bhY = mapRightHandY; 


    //background(0);
    pushMatrix();

    fill(0);
    rect(0, 0, width, height);
    popMatrix();

    // initializing PG Image layers //

    image(bhStrike, 0, 0);
    image(capturedEnergyAnim, 0, 0);
    image(engTrail, 0, 0);
    image(capturedEnergyAnim, 0, 0);
    image(endVoid, 0, 0);
    image(bhOutline, 0, 0);
    image(blackHole, 0, 0);
    image(egOutBurst, 0, 0);


    if (thereIsOnlyVoid==true) {
      background(0);
    }



    //  // Ending waits until energy destroyed
    //} 
    //else if (energyDestroyed==false) {
    //  endVoid.beginDraw();
    //  endVoid.endDraw();
    //}

    //Energy Outbust Dot Motion (linked to energy trail) - PGraphic //

    if (energyDestroyed==false) {
      egOutBurst.beginDraw();
      egOutBurst.fill(random(50, 255), random(50, 255), random(50, 255));
      egOutBurst.clear();
      egOutBurst.blendMode(ADD);
      egOutBurst.strokeWeight(20);
      egOutBurst.stroke(255, random(25, 150));
      egOutBurst.ellipse(egX, egY, 15, 15);
      egOutBurst.endDraw();
    } else if (energyDestroyed==true) {
      egOutBurst.beginDraw();
      egOutBurst.clear();
      egOutBurst.endDraw();
    }


    //Energy trail of randomness - PGraphic//

    if (energyDestroyed==false) { 
      engTrail.beginDraw();
      engTrail.noStroke();
      engTrail.blendMode(ADD);
      engTrail.fill(random(0, 100), random(3, 50), random(150, 200));
      engTrail.ellipse(egX, egY, egGrow, egGrow);
      engTrail.endDraw();
    } else if (energyDestroyed==true) {
      engTrail.beginDraw();
      engTrail.endDraw();
    }

    ///////ANTI-MATTER GAMPLAY///////////////////
    if (handClicked == true && energyDestroyed==false) {

      engTrail.beginDraw();
      engTrail.blendMode(DIFFERENCE);
      engTrail.fill(random(2, 10), random(3, 15), random(40, 70), 120);
      engTrail.ellipse(bhX+(random(-10, 10)), bhY+(random(-10, 10)), 80, 80);
      engTrail.fill(random(2, 10), random(3, 15), random(10, 50), 100);
      engTrail.noStroke();
      engTrail.ellipse(bhX+(random(-50, 100)), bhY+(random(-100, 200)), 20, 20);
      engTrail.ellipse(bhX+(random(-30, 30)), bhY+(random(-20, 20)), 20, 20);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 50, 50);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 20, 20);
      engTrail.ellipse(bhX+(random(-100, 50)), bhY+(random(-50, 50)), 20, 20);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-300, 300)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-100, 100)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-50, 50)), 10, 10);
      engTrail.blendMode(DARKEST);
      engTrail.ellipse(bhX+(random(-30, 30)), bhY+(random(-100, 100)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-30, 300)), bhY+(random(-500, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-30, 300)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-300, 300)), bhY+(random(-100, 100)), 5, 5);
      engTrail.ellipse(bhX+(random(-45, 65)), bhY+(random(-50, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-70, 70)), bhY+(random(-10, 50)), 5, 5);
      engTrail.ellipse(bhX+(random(-100, 300)), bhY+(random(-100, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-30, 90)), bhY+(random(-50, 100)), 5, 5);
      engTrail.endDraw();
    } 


    //Edge Detection (prevents energy burst from traveling out of frame) //

    if (egX >= width - 10) {
      egX = egX + random(-20, -10);
    } else if 
      (egX <= 10) {
      egX = egX + random(10, 20);
    } 

    if (egY >= height - 10) {
      egY = egY + random(-20, -10);
    } else if 
      (egY <= 10) {
      egY = egY + random(10, 20);
    } 

    if (egY >= height - 10 && egX >= width - 10) {
      egY = egY + random(-50, -100);
    } else if 
      (egY <= 10 && egX <= 10) {
      egY = egY + random(50, 100);
    } else if 
      (egY <= 10) {
      egY = egY + random(5, 12);
    } 



    // Black Hole Circle - PGraphic //

    if ( handClicked==false && handClicking==1) {

      blackHole.beginDraw();
      blackHole.clear();
      blackHole.stroke(random(10, 30), 20, 10, 100 + (sin(frameCount/10)*40));
      blackHole.strokeWeight(20);
      blackHole.noFill();
      blackHole.ellipse(mapRightHandX, mapRightHandY, 30, 30);
      blackHole.ellipse(mapRightHandX, mapRightHandY, 40, 40);
      blackHole.ellipse(mapRightHandX, mapRightHandY, 50, 50);
      blackHole.fill(10, 200 + (sin(frameCount/8)*80));
      blackHole.noStroke();
      blackHole.ellipse(bhX, bhY, 30, 30);
      blackHole.blendMode(BLEND);

      blackHole.noFill();
      blackHole.strokeWeight(3);
      blackHole.stroke(50, random(50, 200));
      blackHole.ellipse(mapRightHandX, mapRightHandY, 60, 60);
      blackHole.strokeWeight(10);
      blackHole.stroke(10, random(5, 100), random(10, 200), random(10, 150));
      blackHole.ellipse(mapRightHandX, mapRightHandY, 70, 70);
      blackHole.strokeWeight(2);
      blackHole.stroke(random(2, 15), random(4, 50), random(11, 50), random(50, 100));
      blackHole.ellipse(mapRightHandX, mapRightHandY, 80, 80);
      blackHole.endDraw();
    } else {


      blackHole.beginDraw();
      blackHole.clear();
      blackHole.stroke(255, 100 + (sin(frameCount/10)*40));
      blackHole.strokeWeight(20);
      blackHole.noFill();
      blackHole.ellipse(bhX, bhY, 30, 30);
      blackHole.ellipse(bhX, bhY, 40, 40);
      blackHole.ellipse(bhX, bhY, 50, 50);
      blackHole.fill(0, 200 + (sin(frameCount/8)*80));
      blackHole.noStroke();
      blackHole.ellipse(bhX, bhY, 30, 30);
      blackHole.blendMode(MULTIPLY);
      blackHole.filter(THRESHOLD);
      blackHole.endDraw();
    }
    //   Black Hole Outline - PGraphic //

    bhOutline.beginDraw();
    bhOutline.clear();
    bhOutline.noFill();
    bhOutline.strokeWeight(3);
    bhOutline.stroke(100, random(50, 200));
    bhOutline.ellipse(bhX, bhY, 60, 60);
    bhOutline.strokeWeight(10);
    bhOutline.stroke(100, 100);
    bhOutline.ellipse(bhX, bhY, 70, 70);
    bhOutline.strokeWeight(2);
    bhOutline.stroke(100, random(50, 120));
    bhOutline.ellipse(bhX, bhY, 80, 80);
    bhOutline.endDraw();


    // Gravitational Pull//

   if (dist(bhX, bhY, egX, egY) <= 20) {
      egX = lerp (egX, bhX, .6);
      egY = lerp (egY, bhY, .6);
    }

    //// Energy Anti-Gravity//
     if (dist(bhX, bhY, egX, egY) > 18 && dist(bhX, bhY, egX, egY)<=50) {
      egX = random(-14, 14) +lerp (egX, bhX, antiGravityFar);
      egY = random(-14, 14) +lerp (egY, bhY, antiGravityFar);
    } else if (dist(bhX, bhY, egX, egY) > 50 && dist(bhX, bhY, egX, egY)<80) {
      egX = random(-10, 10) +lerp (egX, bhX, antiGravityClose);
      egY = random(-10, 10) +lerp (egY, bhY, antiGravityClose);
    } else if (dist(bhX, bhY, egX, egY) > 80) {
      egX = egX + random(-8, 8);
      egY = egY+ random(-9, 9);
    }
    
    //Energy Captured Animation Condition //

    if (dist(bhX, bhY, egX, egY) <= 20) {
      energyCaptured = true;
      vSD.soundEngCaptured();

      capturedEnergyAnim.beginDraw();
      capturedEnergyAnim.clear();
      capturedEnergyAnim.noFill();
      capturedEnergyAnim.blendMode(LIGHTEST);
      capturedEnergyAnim.strokeWeight(8);
      capturedEnergyAnim.stroke(250, 224, 255, 190 + (sin(frameCount/4)*40));
      capturedEnergyAnim.ellipse(bhX, bhY, 85, 85);
      capturedEnergyAnim.strokeWeight(7);
      capturedEnergyAnim.stroke(75, 196, 255, 170 + (sin(frameCount/4)*40));
      capturedEnergyAnim.ellipse(bhX, bhY, 80, 80);
      capturedEnergyAnim.stroke(252, 255, 202, 100 + (sin(frameCount/4)*40));
      capturedEnergyAnim.strokeWeight(10);
      capturedEnergyAnim.ellipse(bhX, bhY, 60, 60);
      capturedEnergyAnim.noStroke();
      capturedEnergyAnim.fill(255); 
      capturedEnergyAnim.ellipse(eCaptureX, eCaptureY, 20, 20);
      capturedEnergyAnim.stroke(random(100, 247), 230, random(111, 255), random(50, 255));
      capturedEnergyAnim.strokeCap(SQUARE);
      capturedEnergyAnim.strokeWeight(random(1, 3));
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.blendMode(LIGHTEST);
      capturedEnergyAnim.endDraw();
    } else {
      energyCaptured =false;
      
      capturedEnergyAnim.beginDraw();
      capturedEnergyAnim.clear();
      capturedEnergyAnim.endDraw();
    }

    //Background COlor//
    backgroundDraw.beginDraw();
    backgroundDraw.clear();
    backgroundDraw.background(20);
    backgroundDraw.blendMode(SCREEN);
    backgroundDraw.endDraw();



    // Timer Start & VOID GROW //
    if (energyDestroyed==true) {
      textTimer = textTimer + 1;

      voidGrow = voidGrow *1.07;
      endVoid.beginDraw();
      endVoid.fill(0);
      endVoid.blendMode(REPLACE);
      endVoid.strokeWeight(20);
      endVoid.noStroke();
      endVoid.ellipse(egX + random(10, 100), egY+ random(10, 100), voidGrow, voidGrow);
      endVoid.ellipse(random(0, width), egY+ random(0, height), voidGrow, voidGrow);
      endVoid.ellipse(random(0, width), egY+ random(0, height), voidGrow, voidGrow);
      endVoid.ellipse(random(0, width), egY+ random(0, height), voidGrow, voidGrow);
      endVoid.ellipse(random(0, width), egY+ random(0, height), voidGrow, voidGrow);
      endVoid.endDraw();
    }

    // Print to console for damage and destroy information//
    // println(energyDestroyed);
    // println(damage);
    // println(textTimer + "textTimer");
  }



  //None IF based Timer//

  if (textTimer >= 0 && energyDestroyed==true) {
    gamePlay = false;
    endScreen = true;
  }



  //////////////////////////////////////////////////////////////  
  ////////// END SCENE AFTER DESTRUCTION OF ENERGY ////////////
  //////////////////////////////////////////////////////////////    

  if (endScreen==true) {


    //RESTART TIMER
    textTimer = textTimer + 1;


    //Blackhole mouse control setup //

    bhX = mapRightHandX;
    bhY = mapRightHandY; 

    //Load PGraphics//

    image(endVoid, 0, 0);
    image(bhOutline, 0, 0);
    image(blackHole, 0, 0);
    image(onlyVoidText, 0, 0);

    // End Void takes over & transitions screen to blackness //

    //if (energyDestroyed==true) {


    //  voidGrow = voidGrow *1.1;
    //  endVoid.beginDraw();
    //  endVoid.fill(0);
    //  endVoid.blendMode(DIFFERENCE);
    //  endVoid.strokeWeight(20);
    //  endVoid.noStroke();
    //  endVoid.ellipse(egX + random(10, 100), egY+ random(10, 100), voidGrow, voidGrow);
    //  endVoid.ellipse(random(0, width), egY+ random(0, 720), voidGrow, voidGrow);
    //  endVoid.ellipse(random(0, width), egY+ random(0, 720), voidGrow, voidGrow);
    //  endVoid.ellipse(random(0, width), egY+ random(0, 720), voidGrow, voidGrow);
    //  endVoid.ellipse(random(0, width), egY+ random(0, 720), voidGrow, voidGrow);
    //  endVoid.endDraw();
    //}


    // Black Hole Circle - PGraphic //

    blackHole.beginDraw();
    blackHole.clear();
    blackHole.stroke(255, 100 + (sin(frameCount/10)*40));
    blackHole.strokeWeight(20);
    blackHole.noFill();
    blackHole.ellipse(bhX, bhY, 30, 30);
    blackHole.ellipse(bhX, bhY, 40, 40);
    blackHole.ellipse(bhX, bhY, 50, 50);
    blackHole.fill(0, 200 + (sin(frameCount/8)*80));
    blackHole.noStroke();
    blackHole.ellipse(bhX, bhY, 30, 30);
    blackHole.blendMode(MULTIPLY);
    blackHole.filter(THRESHOLD);
    blackHole.endDraw();

    // Black Hole Outline - PGraphic //

    bhOutline.beginDraw();
    bhOutline.clear();
    bhOutline.noFill();
    bhOutline.strokeWeight(3);
    bhOutline.stroke(100, random(50, 200));
    bhOutline.ellipse(bhX, bhY, 60, 60);
    bhOutline.strokeWeight(10);
    bhOutline.stroke(100, 100);
    bhOutline.ellipse(bhX, bhY, 70, 70);
    bhOutline.strokeWeight(2);
    bhOutline.stroke(100, random(50, 100));
    bhOutline.ellipse(bhX, bhY, 80, 80);
    bhOutline.endDraw();

    // END TEXT 

    if (bhX>=width/2-150 && bhX<width/2+150 && bhY>height/2-150 && bhY<height/2+150) {
      endTextColor = 0;
    } else { 
      endTextColor = 255;
    }

    textAlign(CENTER);
    textSize(21);
    noStroke();
    fill(255, 255, 255, 3*textTimer-200);
    text("NOTHINGNESS HAS BEEN RESTORED", width/2, height/2 - 30); 
    fill(endTextColor, 255, 255, 4*textTimer-400);
    textSize(26);
    text("CLICK HERE TO COMPLETE", width/2, height/2 +20);



    //Play Again Function//
    onlyVtextX = random(-100, width);
    onlyVtextY = random(-40, height);

    if (thereIsOnlyVoid==true) {


      textTimer = textTimer+1;
      m = millis()/1000 - last;


      background(0);
      fill(255, -400 +textTimer/4);
      rect(0, 0, width, height);

      image(onlyVoidText, 0, 0);

      textAlign(CENTER);
      textSize(16);
      noStroke();
      fill(25, -2800 + textTimer);
      text("BUT THERE WASN'T ALWAYS", width*.7, height*.8); 
      fill(255, -3500 +textTimer);
      rect(0, 0, width, height);


      fill(25, -3800 +textTimer);
      rect(0, 0, width, height);


      //Clearing Mouse BlackHole Icon//
      bhOutline.beginDraw();
      bhOutline.clear();
      bhOutline.endDraw();

      blackHole.beginDraw();
      blackHole.clear();
      blackHole.endDraw();


      //Writing ONLY VOID text//
      onlyVoidText.beginDraw();
      onlyVoidText.textSize(random(3, 50));
      onlyVoidText.noStroke();
      onlyVoidText.fill(255);
      onlyVoidText.text("THERE IS ONLY VOID", onlyVtextX, onlyVtextY);
      onlyVoidText.text("THERE IS ONLY VOID", onlyVtextX+random(-width, width), onlyVtextY+random(-height, height));
      onlyVoidText.endDraw();
    } else {
      onlyVoidText.beginDraw();
      onlyVoidText.endDraw();
    }
  }

  // GAME BOARDER //

  stroke(32, 33, 48);
  strokeWeight(5);
  noFill();
  rect(0, 0, width, height);


  /////////DEBUG & PRINT LINE//////
  println("frameRate: " + frameRate);
  // println("gamePlay" + gamePlay);
  //  println("textTimer" + textTimer);

  // println ("fadeUp:" + fadeUp);
  // println ("text 2:" + text2);

////SOUND DESIGN STUFFFS///////

if (gamePlay == true && energyDestroyed ==false && damage <=3) {
     energyInvading = true;
}

if (prePlay == true) {
  
}


  ////////////////////////////////////////////////////
  /////////// MOUSE CLICK FUNCTIONS //////////////////
  ////////////////////// replaces mouse click ////////
  ////////////////////////////////////////////////////

  if (handClicked == true) {

    println("fuck yeah bbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaayyyyyyyyyyyyyyyyybbbbbbbbbbeeeeeeeeeee");
    // Dark strike when hit from Black Hole//

    if ((dist(bhX, bhY, egX, egY)<30) && energyDestroyed==false && gamePlay==true) { 
      engTrail.beginDraw();
      engTrail.noStroke();
      engTrail.blendMode(ADD);
      engTrail.fill(random(0, 100), random(3, 50), random(150, 200));
      engTrail.ellipse(egX, egY, egGrow, egGrow);

      //strikes from black hole in IF statement
      engTrail.noStroke();
      engTrail.fill(10, 2, 50, 200); 
      engTrail.blendMode(DIFFERENCE);

      //large dark circle that surrounds area when energy damaged//
      engTrail.ellipse(bhX, bhY, 700, 700);

      //small scattered dark circles with damage//

      engTrail.blendMode(DARKEST);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 100, 100);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 20, 20);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 20, 20);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-100, 100)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-100, 100)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-400, 400)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-400, 400)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-300, 300)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-300, 300)), 20, 20);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 20, 20);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-500, 500)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-100, 100)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-20, 20)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 10, 10);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-10, 10)), 5, 5);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-500, 500)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-500, 500)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-200, 200)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-300, 300)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 50, 50);
      engTrail.ellipse(bhX+(random(-500, 500)), bhY+(random(-50, 50)), 50, 50);
      engTrail.endDraw();
    }  

    // damage set so energy trail is smaller at 2 damage//
    if ((dist(bhX, bhY, egX, egY)<24) && damage==1) {
      egGrow = egGrow/2;
    }

    // destruction of outburst//

    if ((dist(bhX, bhY, egX, egY)<24) && damage==3) {
      vSD.soundEngInvadeQuiet();      
      textTimer = -90;
      energyDestroyed = true;
      vSD.soundEngDamaged();
      capturedEnergyAnim.beginDraw();
      capturedEnergyAnim.clear();
      capturedEnergyAnim.noFill();
      capturedEnergyAnim.blendMode(LIGHTEST);
      capturedEnergyAnim.strokeWeight(8);
      capturedEnergyAnim.stroke(250, 224, 255, 190 + (sin(frameCount/4)*40));
      capturedEnergyAnim.ellipse(bhX, bhY, 85, 85);
      capturedEnergyAnim.strokeWeight(7);
      capturedEnergyAnim.stroke(75, 196, 255, 170 + (sin(frameCount/4)*40));
      capturedEnergyAnim.ellipse(bhX, bhY, 80, 80);
      capturedEnergyAnim.stroke(252, 255, 202, 100 + (sin(frameCount/4)*40));
      capturedEnergyAnim.strokeWeight(10);
      capturedEnergyAnim.ellipse(bhX, bhY, 60, 60);
      capturedEnergyAnim.noStroke();
      capturedEnergyAnim.fill(255); 
      capturedEnergyAnim.ellipse(eCaptureX, eCaptureY, 20, 20);
      capturedEnergyAnim.stroke(random(100, 247), 230, random(111, 255), random(50, 255));
      capturedEnergyAnim.strokeCap(SQUARE);
      capturedEnergyAnim.strokeWeight(random(1, 3));
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 100)*.65 + eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(-20, 20)*.65, eCaptureY - random(0, 125)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(0, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY - random(1, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(50, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(0, 100)*.65, eCaptureY + random(-50, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX - random(20, 100)*.65, eCaptureY + random(25, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(-100, 50)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY + random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.line(eCaptureX, eCaptureY, eCaptureX + random(0, 100)*.65, eCaptureY - random(0, 100)*.65+ eCaptureLerp);
      capturedEnergyAnim.blendMode(LIGHTEST);
      capturedEnergyAnim.endDraw();

  
      //Saves an Image of preVoid Game//
      //if(recordFrameNum <2) {
      //record = true;
      //recordFrameNum = recordFrameNum + 1;
      //}

      //Saves an Image of preVoid Game//
      if (screenShots <= 3) {
      saveFrame("RestoringTheVoid_ImageSave/BeforeThereWasVoid" + hour() + minute() + second() + month() + year() + ".png");
        screenShots = screenShots +1;
        
   
      }
      

      
    } else if ((dist(bhX, bhY, egX, egY)<24) && damage<3) {
      damage = damage +1;
      egX = random(100, 1200);
      egY = random(50, 700);
      vSD.soundEngDamaged();
    }

////TURN OFF ENERGY SOUND///
    if (energyDestroyed==true) {
      energyInvading = false;
      sqr.stop();
    }
    // Only Void Text functions //

    if (energyDestroyed==true && endScreen==true && bhX>=width/2-75 && 
    bhX>=width/2-150 && bhX<width/2+150 && bhY>height/2-150 && bhY<height/2+150) {
      //textTimer = 0;
     // saveFrame("initiatePrintWatchFolder/printGOgoGO"+"-"+hour()+"."+minute()+"."+second()+"."+millis()+"-"+month()+"."+day()+"."+year()+".png");
      thereIsOnlyVoid = true;
    } 

    if (energyDestroyed==false) {
      thereIsOnlyVoid = false;
    }

    ////Clean Background //
    if (thereIsOnlyVoid==true) {
      textTimer = textTimer+1;
    }






    handClicked = false;
  }
  
/////////////////////////////////////
/////////RESET GAME/////////////////
/////////////////////////////////////
  if (keyPressed == true) {
      if (key == 'W' || key == 'w') {
      vSD.vdSoundOff();

        energyDestroyed = true; 
        textTimer = 5000;
      }
    if (energyDestroyed == true && textTimer >= 4098) {
      vSD.vdSoundOff();
    }
  }  
/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
}
