/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import com.leapmotion.leap.Controller;
import com.leapmotion.leap.Frame;
import com.leapmotion.leap.Gesture;
import com.leapmotion.leap.Listener;
import com.leapmotion.leap.Vector;
import de.voidplus.leapmotion.CircleGesture;
import de.voidplus.leapmotion.Device;
import de.voidplus.leapmotion.Finger;
import de.voidplus.leapmotion.Hand;
import de.voidplus.leapmotion.Image;
import de.voidplus.leapmotion.KeyTapGesture;
import de.voidplus.leapmotion.ScreenTapGesture;
import de.voidplus.leapmotion.SwipeGesture;
import de.voidplus.leapmotion.Tool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.core.PVector;

public class LeapMotion {
    private static final String NAME = "Leap Motion";
    private static final String REPO = "https://github.com/nok/leap-motion-processing";
    private static final String VERSION = "2.3.1.6";
    private static final String SDK_VERSION = "2.3.1+31549";
    private final PApplet parent;
    protected boolean is2D;
    private boolean verbose;
    private boolean recognition;
    private PVector world;
    private PVector origin;
    private ArrayList<Hand> hands;
    private ArrayList<Finger> fingers;
    private ArrayList<Finger> outstretchedFingers;
    private ArrayList<Finger> outstretchedFingersByAngel;
    private ArrayList<Tool> tools;
    private ArrayList<Device> devices;
    private ArrayList<Image> images;
    private Frame frame;
    private Frame lastFrame;
    private final Controller controller;
    private final Listener listener;

    public LeapMotion(PApplet pApplet, boolean bl) {
        this.parent = pApplet;
        this.is2D = pApplet.g.is2D();
        this.setVerbose(bl);
        this.recognition = false;
        this.println(String.format("# %s Library v%s - Leap Motion SDK v%s - %s", NAME, this.getVersion(), this.getVersionSDK(), REPO), false);
        this.setWorld(200, 500, 200);
        this.hands = new ArrayList();
        this.fingers = new ArrayList();
        this.outstretchedFingers = new ArrayList();
        this.outstretchedFingersByAngel = new ArrayList();
        this.tools = new ArrayList();
        this.devices = new ArrayList();
        this.images = new ArrayList();
        this.frame = Frame.invalid();
        this.lastFrame = Frame.invalid();
        this.controller = new Controller();
        this.listener = new Listener(){

            public void onInit(Controller controller) {
                LeapMotion.this.dispatch("leapOnInit");
            }

            public void onConnect(Controller controller) {
                LeapMotion.this.dispatch("leapOnConnect");
            }

            public void onDisconnect(Controller controller) {
                LeapMotion.this.dispatch("leapOnDisconnect");
            }

            public void onExit(Controller controller) {
                LeapMotion.this.dispatch("leapOnExit");
            }

            public void onFrame(Controller controller) {
                LeapMotion.this.frame = controller.frame();
                LeapMotion.this.dispatch("leapOnFrame");
            }
        };
        this.controller.addListener(this.listener);
        this.allowBackgroundApps();
        this.parent.registerMethod("dispose", (Object)this);
    }

    public LeapMotion(PApplet pApplet) {
        this(pApplet, false);
    }

    public int getFrameRate() {
        if (this.isConnected()) {
            return (int)this.frame.currentFramesPerSecond();
        }
        return 0;
    }

    public long getTimestamp() {
        if (this.isConnected()) {
            return this.frame.timestamp();
        }
        return 0L;
    }

    public long getId() {
        if (this.isConnected()) {
            return this.frame.id();
        }
        return Frame.invalid().id();
    }

    public void printPolicyFlags() {
        for (Controller.PolicyFlag policyFlag : Controller.PolicyFlag.values()) {
            if (!this.controller.isPolicySet(policyFlag)) continue;
            this.log(String.format("'%s' is set.", policyFlag.toString()));
        }
    }

    public LeapMotion allowBackgroundApps() {
        if (!this.controller.isPolicySet(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES)) {
            this.controller.setPolicy(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES);
        }
        return this;
    }

    public LeapMotion withBackgroundFrames() {
        this.log("'withBackgroundFrames()' is deprecated. Please use 'allowBackgroundApps()'.");
        return this.allowBackgroundApps();
    }

    public LeapMotion runInBackground(boolean bl) {
        this.log("'runInBackground()' is deprecated. Please use 'allowBackgroundApps()'.");
        return this.allowBackgroundApps();
    }

    public LeapMotion allowRunInBackground() {
        this.log("'allowRunInBackground()' is deprecated. Please use 'allowBackgroundApps()'.");
        return this.allowBackgroundApps();
    }

    public LeapMotion withoutBackgroundFrames() {
        this.log("'withoutBackgroundFrames()' is deprecated. Please use 'disallowBackgroundApps()'.");
        return this.disallowBackgroundApps();
    }

    public LeapMotion disallowBackgroundApps() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES)) {
            this.controller.clearPolicy(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES);
        }
        return this;
    }

    public LeapMotion setWorld(int n, int n2, int n3) {
        return this.setWorld(new PVector((float)n, (float)n2, (float)n3));
    }

    public LeapMotion setWorld(PVector pVector) {
        this.world = pVector;
        return this;
    }

    public LeapMotion moveWorld(int n, int n2, int n3) {
        return this.moveWorld(new PVector((float)n, (float)n2, (float)n3));
    }

    public LeapMotion moveWorld(PVector pVector) {
        this.origin = pVector;
        return this;
    }

    public boolean isConnected() {
        return this.controller.isConnected();
    }

    public Controller getController() {
        return this.controller;
    }

    public ArrayList<Device> getDevices() {
        this.devices.clear();
        if (this.isConnected() && !this.getController().devices().isEmpty()) {
            for (com.leapmotion.leap.Device device : this.getController().devices()) {
                this.devices.add(new Device(this.parent, this, device));
            }
        }
        return this.devices;
    }

    private static boolean isValid(com.leapmotion.leap.Hand hand) {
        return hand != null && hand.isValid();
    }

    public boolean hasHands() {
        return this.isConnected() && !this.frame.hands().isEmpty();
    }

    public int countHands() {
        return this.isConnected() ? this.frame.hands().count() : 0;
    }

    public Hand getHand(Integer n) {
        com.leapmotion.leap.Hand hand;
        if (!this.hasHands() && LeapMotion.isValid(hand = this.frame.hand(n.intValue()))) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    public ArrayList<Hand> getHands() {
        this.hands.clear();
        if (this.hasHands()) {
            for (com.leapmotion.leap.Hand hand : this.frame.hands()) {
                if (!LeapMotion.isValid(hand)) continue;
                this.hands.add(new Hand(this.parent, this, hand));
            }
        }
        return this.hands;
    }

    public Hand getFrontHand() {
        com.leapmotion.leap.Hand hand;
        if (!this.hasHands() && LeapMotion.isValid(hand = this.frame.hands().frontmost())) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    public Hand getLeftHand() {
        com.leapmotion.leap.Hand hand;
        if (this.hasHands() && LeapMotion.isValid(hand = this.frame.hands().leftmost())) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    public Hand getRightHand() {
        com.leapmotion.leap.Hand hand;
        if (this.hasHands() && LeapMotion.isValid(hand = this.frame.hands().rightmost())) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    private static boolean isValid(com.leapmotion.leap.Finger finger) {
        return finger != null && finger.isValid();
    }

    public boolean hasFingers() {
        return this.isConnected() && !this.frame.fingers().isEmpty();
    }

    public Finger getFinger(Integer n) {
        com.leapmotion.leap.Finger finger;
        if (this.hasFingers() && !LeapMotion.isValid(finger = this.frame.finger(n.intValue()))) {
            return new Finger(this.parent, this, finger);
        }
        return null;
    }

    public ArrayList<Finger> getFingers() {
        this.fingers.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this.frame.fingers()) {
                if (!finger.isValid()) continue;
                this.fingers.add(new Finger(this.parent, this, finger));
            }
        }
        return this.fingers;
    }

    public ArrayList<Finger> getOutstretchedFingers() {
        this.outstretchedFingers.clear();
        if (!this.frame.fingers().extended().isEmpty()) {
            for (com.leapmotion.leap.Finger finger : this.frame.fingers().extended()) {
                this.outstretchedFingers.add(new Finger(this.parent, this, finger));
            }
        }
        return this.outstretchedFingers;
    }

    public ArrayList<Finger> getOutstretchedFingersByAngel(int n) {
        this.outstretchedFingersByAngel.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this.frame.fingers()) {
                if (!finger.isValid()) continue;
                Finger finger2 = new Finger(this.parent, this, finger);
                float f = 0.0f;
                for (int i = 0; i < 4; ++i) {
                    f += PVector.dist((PVector)finger2.getBone(i).getNextJoint(), (PVector)finger2.getBone(i).getPrevJoint());
                }
                PVector pVector = finger2.getBone(0).getNextJoint();
                int n2 = finger2.getType() != 0 ? 3 : 2;
                float f2 = PVector.dist((PVector)pVector, (PVector)finger2.getBone(n2).getPrevJoint());
                if (!(f2 / f * 100.0f >= (float)n)) continue;
                this.outstretchedFingersByAngel.add(finger2);
            }
        }
        return this.outstretchedFingersByAngel;
    }

    public ArrayList<Finger> getOutstrechtedFingersByAngel() {
        return this.getOutstretchedFingersByAngel(75);
    }

    public int countFingers() {
        if (this.isConnected()) {
            return this.frame.fingers().count();
        }
        return 0;
    }

    public Finger getFrontFinger() {
        if (this.hasFingers()) {
            return new Finger(this.parent, this, this.frame.fingers().frontmost());
        }
        return null;
    }

    public Finger getLeftFinger() {
        if (this.hasFingers()) {
            return new Finger(this.parent, this, this.frame.fingers().leftmost());
        }
        return null;
    }

    public Finger getRightFinger() {
        if (this.hasFingers()) {
            return new Finger(this.parent, this, this.frame.fingers().rightmost());
        }
        return null;
    }

    private static boolean isValid(com.leapmotion.leap.Tool tool) {
        return tool != null && tool.isValid();
    }

    public boolean hasTools() {
        return this.isConnected() && !this.frame.tools().isEmpty();
    }

    public Tool getTool(Integer n) {
        com.leapmotion.leap.Tool tool;
        if (this.hasTools() && !LeapMotion.isValid(tool = this.frame.tool(n.intValue()))) {
            return new Tool(this.parent, this, tool);
        }
        return null;
    }

    public ArrayList<Tool> getTools() {
        this.tools.clear();
        if (this.hasTools()) {
            for (com.leapmotion.leap.Tool tool : this.frame.tools()) {
                if (!LeapMotion.isValid(tool)) continue;
                this.tools.add(new Tool(this.parent, this, tool));
            }
        }
        return this.tools;
    }

    public int countTools() {
        if (this.isConnected()) {
            return this.frame.tools().count();
        }
        return 0;
    }

    public Tool getFrontTool() {
        if (this.hasTools()) {
            return new Tool(this.parent, this, this.frame.tools().frontmost());
        }
        return null;
    }

    public Tool getLeftTool() {
        if (this.hasTools()) {
            return new Tool(this.parent, this, this.frame.tools().leftmost());
        }
        return null;
    }

    public Tool getRightTool() {
        if (this.hasTools()) {
            return new Tool(this.parent, this, this.frame.tools().rightmost());
        }
        return null;
    }

    public LeapMotion allowImages() {
        if (!this.controller.isPolicySet(Controller.PolicyFlag.POLICY_IMAGES)) {
            this.controller.setPolicy(Controller.PolicyFlag.POLICY_IMAGES);
        }
        return this;
    }

    public LeapMotion withCameraImages() {
        this.log("'withCameraImages()' is deprecated. Please use 'allowImages()'.");
        return this.allowImages();
    }

    public LeapMotion disallowImages() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_IMAGES)) {
            this.controller.clearPolicy(Controller.PolicyFlag.POLICY_IMAGES);
        }
        return this;
    }

    public LeapMotion withoutCameraImages() {
        this.log("'withoutCameraImages()' is deprecated. Please use 'disallowImages()'.");
        return this.disallowImages();
    }

    public boolean hasImages() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_IMAGES)) {
            if (!this.controller.frame().images().isEmpty()) {
                return true;
            }
        } else {
            this.allowImages();
        }
        return false;
    }

    public ArrayList<Image> getImages() {
        this.images.clear();
        if (this.hasImages()) {
            for (com.leapmotion.leap.Image image : this.controller.frame().images()) {
                if (!image.isValid()) continue;
                this.images.add(new Image(this.parent, this, image));
            }
        }
        return this.images;
    }

    public LeapMotion allowHdm() {
        if (!this.controller.isPolicySet(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD)) {
            this.controller.setPolicy(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD);
        }
        return this;
    }

    public LeapMotion withOptimizedHdm() {
        this.log("'withOptimizedHdm()' is deprecated. Please use 'allowHdm()'.");
        return this.allowHdm();
    }

    public LeapMotion disallowHdm() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD)) {
            this.controller.clearPolicy(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD);
        }
        return this;
    }

    public LeapMotion withoutOptimizedHdm() {
        this.log("'withoutOptimizedHdm()' is deprecated. Please use 'disallowHdm()'.");
        return this.disallowHdm();
    }

    public LeapMotion withGestures(String string) {
        string = string.trim().toUpperCase();
        List<String> list = Arrays.asList(string.split("\\s*,\\s*"));
        this.recognition = false;
        block6: for (String string2 : list) {
            string2 = "TYPE_" + string2;
            this.recognition = true;
            switch (Gesture.Type.valueOf((String)string2)) {
                case TYPE_SWIPE: {
                    this.controller.enableGesture(Gesture.Type.TYPE_SWIPE);
                    continue block6;
                }
                case TYPE_CIRCLE: {
                    this.controller.enableGesture(Gesture.Type.TYPE_CIRCLE);
                    continue block6;
                }
                case TYPE_SCREEN_TAP: {
                    this.controller.enableGesture(Gesture.Type.TYPE_SCREEN_TAP);
                    continue block6;
                }
                case TYPE_KEY_TAP: {
                    this.controller.enableGesture(Gesture.Type.TYPE_KEY_TAP);
                    continue block6;
                }
            }
            this.recognition = false;
        }
        if (this.recognition) {
            this.parent.registerMethod("pre", (Object)this);
        } else {
            this.parent.unregisterMethod("pre", (Object)this);
        }
        return this;
    }

    public LeapMotion allowGestures(String string) {
        return this.withGestures(string);
    }

    public LeapMotion withGestures() {
        return this.withGestures("swipe, circle, screen_tap, key_tap");
    }

    public LeapMotion allowGestures() {
        return this.withGestures("swipe, circle, screen_tap, key_tap");
    }

    public LeapMotion withoutGestures() {
        this.parent.unregisterMethod("pre", (Object)this);
        this.recognition = false;
        return this;
    }

    public void pre() {
        this.check();
    }

    public void dispose() {
        this.controller.removeListener(this.listener);
    }

    private void check() {
        if (this.isConnected() && this.recognition) {
            block6: for (Gesture gesture : this.frame.gestures(this.lastFrame)) {
                if (!gesture.isValid()) continue;
                int n = 2;
                switch (gesture.type()) {
                    case TYPE_CIRCLE: {
                        if (gesture.state() == Gesture.State.STATE_START) {
                            n = 1;
                        } else if (gesture.state() == Gesture.State.STATE_STOP) {
                            n = 3;
                        }
                        this.dispatch("leapOnCircleGesture", CircleGesture.class, Integer.TYPE, new CircleGesture(this.parent, this, gesture), n);
                        continue block6;
                    }
                    case TYPE_SWIPE: {
                        if (gesture.state() == Gesture.State.STATE_START) {
                            n = 1;
                        } else if (gesture.state() == Gesture.State.STATE_STOP) {
                            n = 3;
                        }
                        this.dispatch("leapOnSwipeGesture", SwipeGesture.class, Integer.TYPE, new SwipeGesture(this.parent, this, gesture), n);
                        continue block6;
                    }
                    case TYPE_SCREEN_TAP: {
                        if (gesture.state() != Gesture.State.STATE_STOP) continue block6;
                        this.dispatch("leapOnScreenTapGesture", ScreenTapGesture.class, new ScreenTapGesture(this.parent, this, gesture));
                        continue block6;
                    }
                    case TYPE_KEY_TAP: {
                        if (gesture.state() != Gesture.State.STATE_STOP) continue block6;
                        this.dispatch("leapOnKeyTapGesture", KeyTapGesture.class, new KeyTapGesture(this.parent, this, gesture));
                        continue block6;
                    }
                }
                this.log("Unknown gesture type.");
            }
            this.lastFrame = this.frame;
        }
    }

    public LeapMotion setGestureCircleMinRadius(float f) {
        return this.setConfig("Gesture.Circle.MinRadius", f);
    }

    public LeapMotion setGestureCircleMinArc(float f) {
        return this.setConfig("Gesture.Circle.MinArc", PApplet.radians((float)f));
    }

    public LeapMotion setGestureSwipeMinLength(float f) {
        return this.setConfig("Gesture.Swipe.MinLength", f);
    }

    public LeapMotion setGestureSwipeMinVelocity(float f) {
        return this.setConfig("Gesture.Swipe.MinVelocity", f);
    }

    public LeapMotion setGestureKeyTapMinDownVelocity(float f) {
        return this.setConfig("Gesture.KeyTap.MinDownVelocity", f);
    }

    public LeapMotion setGestureKeyTapHistorySeconds(float f) {
        return this.setConfig("Gesture.KeyTap.HistorySeconds", f);
    }

    public LeapMotion setGestureKeyTapMinDistance(float f) {
        return this.setConfig("Gesture.KeyTap.MinDistance", f);
    }

    public LeapMotion setGestureScreenTapMinForwardVelocity(float f) {
        return this.setConfig("Gesture.ScreenTap.MinForwardVelocity", f);
    }

    public LeapMotion setGestureScreenTapHistorySeconds(float f) {
        return this.setConfig("Gesture.ScreenTap.HistorySeconds", f);
    }

    public LeapMotion setGestureScreenTapMinDistance(float f) {
        return this.setConfig("Gesture.ScreenTap.MinDistance", f);
    }

    public LeapMotion setConfig(String string, int n) {
        if (this.controller.isConnected() && this.controller.config().setInt32(string, n)) {
            this.controller.config().save();
        }
        this.controller.config().save();
        return this;
    }

    public LeapMotion setConfig(String string, float f) {
        if (this.controller.isConnected() && this.controller.config().setFloat(string, f)) {
            this.controller.config().save();
        }
        return this;
    }

    public LeapMotion setConfig(String string, boolean bl) {
        if (this.controller.isConnected() && this.controller.config().setBool(string, bl)) {
            this.controller.config().save();
        }
        return this;
    }

    public LeapMotion setConfig(String string, String string2) {
        if (this.controller.isConnected() && this.controller.config().setString(string, string2)) {
            this.controller.config().save();
        }
        return this;
    }

    protected PVector map(Vector vector) {
        PVector pVector = new PVector();
        pVector.x = vector.getX() > 0.0f ? PApplet.lerp((float)((float)this.parent.width * 0.5f), (float)this.parent.width, (float)(vector.getX() / this.world.x)) : PApplet.lerp((float)((float)this.parent.width * 0.5f), (float)0.0f, (float)(-vector.getX() / this.world.x));
        pVector.y = PApplet.lerp((float)this.parent.height, (float)0.0f, (float)(vector.getY() / this.world.y));
        pVector.z = PApplet.lerp((float)50.0f, (float)0.0f, (float)(vector.getZ() / this.world.z));
        return this.move(pVector);
    }

    protected PVector convert(Vector vector) {
        return this.move(new PVector(vector.getX(), vector.getY(), vector.getZ()));
    }

    private PVector move(PVector pVector) {
        if (this.origin != null) {
            pVector.x += this.origin.x;
            pVector.y += this.origin.y;
            pVector.z += this.origin.z;
        }
        return pVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatch(String string) {
        boolean bl = false;
        try {
            this.parent.getClass().getMethod(string, new Class[0]).invoke((Object)this.parent, new Object[0]);
            bl = true;
            if (!bl) return;
        }
        catch (Exception exception) {
            if (!bl) return;
            this.log(String.format("Callback %s();", string));
            return;
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                this.log(String.format("Callback %s();", string));
                throw throwable;
            }
        }
        this.log(String.format("Callback %s();", string));
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatch(String string, Class clazz, Object object) {
        boolean bl = false;
        try {
            this.parent.getClass().getMethod(string, clazz).invoke((Object)this.parent, object);
            bl = true;
            if (!bl) return;
        }
        catch (Exception exception) {
            if (!bl) return;
            this.log(String.format("Callback %s();", string));
            return;
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                this.log(String.format("Callback %s();", string));
                throw throwable;
            }
        }
        this.log(String.format("Callback %s();", string));
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatch(String string, Class clazz, Class clazz2, Object object, Object object2) {
        boolean bl = false;
        try {
            this.parent.getClass().getMethod(string, clazz, clazz2).invoke((Object)this.parent, object, object2);
            bl = true;
            if (!bl) return;
        }
        catch (Exception exception) {
            if (!bl) return;
            this.log(String.format("Callback %s();", string));
            return;
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                this.log(String.format("Callback %s();", string));
                throw throwable;
            }
        }
        this.log(String.format("Callback %s();", string));
        return;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getVersionSDK() {
        return SDK_VERSION;
    }

    public LeapMotion setVerbose(boolean bl) {
        this.verbose = bl;
        return this;
    }

    private void println(String string, boolean bl) {
        if (bl) {
            PApplet.println((String)String.format("# %s: %s", NAME, string));
        } else {
            PApplet.println((String)string);
        }
    }

    private void println(String string) {
        this.println(string, true);
    }

    private void log(String string) {
        if (this.verbose) {
            this.println(string);
        }
    }
}

