/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import com.leapmotion.leap.Bone;
import com.leapmotion.leap.Finger;
import de.voidplus.leapmotion.Bone;
import de.voidplus.leapmotion.LeapMotion;
import de.voidplus.leapmotion.Pointable;
import de.voidplus.leapmotion.RawAccess;
import processing.core.PApplet;
import processing.core.PVector;

public class Finger
extends Pointable
implements RawAccess<com.leapmotion.leap.Finger> {
    private com.leapmotion.leap.Finger _finger;

    public Finger(PApplet pApplet, LeapMotion leapMotion, com.leapmotion.leap.Finger finger) {
        super(pApplet, leapMotion, (com.leapmotion.leap.Pointable)finger);
        this._finger = finger;
    }

    @Override
    public boolean isValid() {
        return this._finger.isValid();
    }

    @Override
    public com.leapmotion.leap.Finger getRaw() {
        return this._finger;
    }

    public boolean isExtended() {
        return this._finger.isExtended();
    }

    public PVector getPositionOfJointTip() {
        return this.leap.map(this._finger.jointPosition(Finger.Joint.JOINT_TIP));
    }

    public PVector getPositionOfJointMcp() {
        return this.leap.map(this._finger.jointPosition(Finger.Joint.JOINT_MCP));
    }

    public PVector getPositionOfJointPip() {
        return this.leap.map(this._finger.jointPosition(Finger.Joint.JOINT_PIP));
    }

    public PVector getPositionOfJointDip() {
        return this.leap.map(this._finger.jointPosition(Finger.Joint.JOINT_DIP));
    }

    public PVector getRawPositionOfJointTip() {
        return this.leap.convert(this._finger.jointPosition(Finger.Joint.JOINT_TIP));
    }

    public PVector getRawPositionOfJointMcp() {
        return this.leap.convert(this._finger.jointPosition(Finger.Joint.JOINT_MCP));
    }

    public PVector getRawPositionOfJointPip() {
        return this.leap.convert(this._finger.jointPosition(Finger.Joint.JOINT_PIP));
    }

    public PVector getRawPositionOfJointDip() {
        return this.leap.convert(this._finger.jointPosition(Finger.Joint.JOINT_DIP));
    }

    public int getType() {
        Finger.Type type = this._finger.type();
        switch (type) {
            case TYPE_THUMB: {
                return 0;
            }
            case TYPE_INDEX: {
                return 1;
            }
            case TYPE_MIDDLE: {
                return 2;
            }
            case TYPE_RING: {
                return 3;
            }
            case TYPE_PINKY: {
                return 4;
            }
        }
        return -1;
    }

    public String getTypeName() {
        Finger.Type type = this._finger.type();
        switch (type) {
            case TYPE_THUMB: {
                return "thumb";
            }
            case TYPE_INDEX: {
                return "index";
            }
            case TYPE_MIDDLE: {
                return "middle";
            }
            case TYPE_RING: {
                return "ring";
            }
            case TYPE_PINKY: {
                return "pinky";
            }
        }
        return "";
    }

    public Bone getBone(String string) {
        if ((string = string.toLowerCase()).equals("distal")) {
            return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_DISTAL));
        }
        if (string.equals("intermediate")) {
            return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_INTERMEDIATE));
        }
        if (string.equals("proximal")) {
            return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_PROXIMAL));
        }
        if (string.equals("metacarpal")) {
            return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_METACARPAL));
        }
        return null;
    }

    public Bone getBone(int n) {
        switch (n) {
            case 0: {
                return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_DISTAL));
            }
            case 1: {
                return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_INTERMEDIATE));
            }
            case 2: {
                return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_PROXIMAL));
            }
            case 3: {
                return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_METACARPAL));
            }
        }
        return null;
    }

    public Bone getDistalBone() {
        return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_DISTAL));
    }

    public Bone getIntermediateBone() {
        return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_INTERMEDIATE));
    }

    public Bone getMetacarpalBone() {
        return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_METACARPAL));
    }

    public Bone getProximalBone() {
        return new Bone(this.parent, this.leap, this._finger.bone(Bone.Type.TYPE_PROXIMAL));
    }

    public void drawBones() {
        this.parent.stroke(0, this.isExtended() ? 170.0f : 35.0f);
        this.getBone(0).draw();
        this.getBone(1).draw();
        this.getBone(2).draw();
        if (this.getType() != 0) {
            this.getBone(3).draw();
        }
    }

    public void drawJoints(float f) {
        this.parent.noStroke();
        this.parent.fill(0);
        PVector pVector = this.getPositionOfJointTip();
        PVector pVector2 = this.getPositionOfJointMcp();
        PVector pVector3 = this.getPositionOfJointPip();
        PVector pVector4 = this.getPositionOfJointDip();
        if (this.leap.is2D) {
            this.parent.ellipseMode(3);
            this.parent.ellipse(pVector.x, pVector.y, f, f);
            this.parent.ellipse(pVector3.x, pVector3.y, f, f);
            this.parent.ellipse(pVector4.x, pVector4.y, f, f);
            if (this.getType() != 0) {
                this.parent.ellipse(pVector2.x, pVector2.y, f, f);
            }
        } else {
            this.parent.sphereDetail(20);
            this.parent.pushMatrix();
            this.parent.translate(pVector.x, pVector.y, pVector.z);
            this.parent.sphere(f);
            this.parent.popMatrix();
            this.parent.pushMatrix();
            this.parent.translate(pVector3.x, pVector3.y, pVector3.z);
            this.parent.sphere(f);
            this.parent.popMatrix();
            this.parent.pushMatrix();
            this.parent.translate(pVector4.x, pVector4.y, pVector4.z);
            this.parent.sphere(f);
            this.parent.popMatrix();
            if (this.getType() != 0) {
                this.parent.pushMatrix();
                this.parent.translate(pVector2.x, pVector2.y, pVector2.z);
                this.parent.sphere(f);
                this.parent.popMatrix();
            }
        }
    }

    public void drawJoints() {
        this.drawJoints(3.0f);
    }

    public void drawName(int n, int n2, int n3) {
        PVector pVector = this.getPosition();
        this.parent.fill(0);
        this.parent.text(this.getTypeName(), pVector.x + (float)n, pVector.y + (float)n2, pVector.z + (float)n3);
    }

    public void drawName() {
        this.drawName(-15, -15, 0);
    }

    public void draw(float f) {
        this.drawBones();
        this.drawJoints(f);
        this.drawName();
    }

    public void draw() {
        this.draw(3.0f);
    }
}

